function export_drag_table(T, opts)
% EXPORT_DRAG_TABLE  Exporta tabla D(M) a CSV y/o LaTeX (opcional).
if nargin<2, opts=struct(); end
if ~isfield(opts,'csv'),   opts.csv='';   end
if ~isfield(opts,'latex'), opts.latex=''; end

if ~isempty(opts.csv)
    try, writetable(T, opts.csv); fprintf('CSV escrito: %s\n', opts.csv);
    catch E, warning('%s: %s', E.identifier, E.message); end
end

if ~isempty(opts.latex)
    try
        f=fopen(opts.latex,'w'); assert(f>0);
        fprintf(f,'\\begin{tabular}{@{}c c c c c c c@{}}\\toprule\n');
        fprintf(f,'$M$ & $C_{D0,tot}$ & $C_D$ & $C_L$ & $D_{par}$ [lbf] & $D_{ind}$ [lbf] & $D_{tot}$ [lbf] \\\\ \\midrule\n');
        for i=1:height(T)
            fprintf(f,'%.2f & %.6f & %.6f & %.4f & %d & %d & %d \\\\\n', ...
                T.M(i),T.CD0_tot(i),T.CD(i),T.CL(i),T.D_par_lbf(i),T.D_ind_lbf(i),T.D_tot_lbf(i));
        end
        fprintf(f,'\\bottomrule\\end{tabular}\n'); fclose(f);
        fprintf('LaTeX escrito: %s\n', opts.latex);
    catch E, warning('%s: %s', E.identifier, E.message); end
end
end


% ============================================================
%   AIRCRAFT PERFORMANCE & DESIGN – PIPELINE ASIGNACIONES 1–4
% ============================================================
%
% 🔹 Propósito
% Este conjunto de funciones automatiza los cálculos de 
% performance (Asignaciones 1–4), permitiendo trabajar tanto
% con CD0 base constante como con la curva ΔCD0(M) digitalizada.
% Los módulos están diseñados para ejecutarse en cadena y 
% generar tablas, gráficas y resúmenes con explicación.
%
% 🔹 Flujo de ejecución principal (pipeline)
%
% run_airperf.m
%   └─> isa_std_atmos     → atm
%   └─> base_quantities   → base
%   └─> build_CD0_total   → CD0tot
%   └─> build_drag_table  → T
%   └─> check_mach_cap    → cap
%   └─> breguet_ER        → breg
%   └─> describe_airperf_outputs(atm, base, CD0tot, T, cap, breg)
%
% 🔹 Descripción de cada módulo
%
% isa_std_atmos(h_ft)
%   ENTRADA: altitud [ft]
%   SALIDA : atm struct con:
%       T_K, T_R, a_fts, rho, sigma
%   → Modelo de atmósfera estándar (ISA).
%
% base_quantities(atm, inputs)
%   ENTRADA: atm, struct inputs con {S, W, AR, e, TSFC, T_SL_tot}
%   SALIDA : base struct con:
%       q0, q0S, k, TSFC corregido
%   → Calcula magnitudes base aerodinámicas.
%
% build_CD0_total(M_grid, CD0_base, dCD0)
%   ENTRADA: malla Mach, CD0_base, curva ΔCD0(M)
%   SALIDA : CD0tot vector
%   → Construye la curva de arrastre parasitario.
%     (dos caminos: CD0_base constante o digitalización ΔCD0).
%
% build_drag_table(M_grid, CD0tot, base, inputs)
%   ENTRADA: Mach grid, CD0tot, base, inputs
%   SALIDA : tabla T con columnas:
%       M, C_D0, C_D, C_L, D_par, D_ind, D_tot
%   → Calcula arrastres parasitario, inducido y total.
%
% check_mach_cap(M_cap, CD0tot, base, inputs)
%   ENTRADA: Mach operativo
%   SALIDA : cap struct con:
%       C_D_cap, D_cap, T_avail
%   → Compara empuje disponible vs arrastre.
%     Determina si gobierna Mach límite o empuje.
%
% breguet_ER(inputs, base, atm)
%   ENTRADA: TSFC, (L/D), Wi/Wf, Mach operativo
%   SALIDA : breg struct con:
%       E (endurance), R (range)
%   → Implementa ecuaciones de Breguet.
%
% describe_airperf_outputs(atm, base, CD0tot, T, cap, breg)
%   ENTRADA: todos los structs anteriores
%   SALIDA : impresión en consola con unidades y explicación
%   → Resume y documenta resultados.
%
% 🔹 Notas de uso
% - Siempre arrancar desde run_airperf.m
% - Cada módulo puede probarse aislado llamando con sus argumentos.
% - Diseñado para Matlab Online con entrada/salida clara y
%   documentada para reportes técnicos en LaTeX.
%
% ============================================================
